<?php
if (!defined('ABSPATH')) exit;

class Audit_Settings {
    public static function render_settings_page() {
        // Save settings
        if (isset($_POST['at_save_settings']) && check_admin_referer('at_save_settings_nonce')) {
            update_option('at_view_capability', sanitize_text_field($_POST['at_view_capability']));
            update_option('at_delete_capability', sanitize_text_field($_POST['at_delete_capability']));
            update_option('at_log_retention_days', max(1, intval($_POST['at_log_retention_days'])));

            if (!empty($_POST['at_delete_all_logs'])) {
                self::delete_all_logs();
                echo '<div class="updated"><p>✅ All logs deleted.</p></div>';
            } else {
                echo '<div class="updated"><p>✅ Settings saved.</p></div>';
            }
        }

        // Get current values
        $view_cap = get_option('at_view_capability', 'read');
        $delete_cap = get_option('at_delete_capability', 'delete_posts');
        $retention = get_option('at_log_retention_days', 30);

        ?>
        <div class="wrap">
            <h1>Audit Trail Settings</h1>
            <form method="post">
                <?php wp_nonce_field('at_save_settings_nonce'); ?>

                <table class="form-table">
                    <tr>
                        <th scope="row"><label for="at_view_capability">Who can access audit trail?</label></th>
                        <td>
                            <select name="at_view_capability" id="at_view_capability">
                                <?php self::render_capability_options($view_cap); ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="at_delete_capability">Who can delete their own logs?</label></th>
                        <td>
                            <select name="at_delete_capability" id="at_delete_capability">
                                <?php self::render_capability_options($delete_cap); ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="at_log_retention_days">Keep logs for (days)</label></th>
                        <td><input type="number" name="at_log_retention_days" value="<?php echo esc_attr($retention); ?>" min="1" /></td>
                    </tr>
                </table>

                <h2>Delete Logs</h2>
                <p>
                    <label>
                        <input type="checkbox" name="at_delete_all_logs" value="1"> Delete all logs now
                    </label>
                </p>

                <?php submit_button('Save Settings'); ?>
            </form>
        </div>
        <?php
    }

    private static function render_capability_options($selected) {
        $caps = [
            'read' => 'Read (Default)',
            'edit_posts' => 'Editor & above',
            'publish_posts' => 'Publish Posts',
            'delete_posts' => 'Delete Posts',
            'manage_options' => 'Administrators only',
        ];
        foreach ($caps as $value => $label) {
            printf('<option value="%s"%s>%s</option>', esc_attr($value), selected($selected, $value, false), esc_html($label));
        }
    }

    public static function delete_all_logs() {
        global $wpdb;
        $wpdb->query("DELETE FROM {$wpdb->prefix}audit_trail_login_history");
        $wpdb->query("DELETE FROM {$wpdb->prefix}audit_trail_user_activities");
    }

    // Helper for checking permission
    public static function current_user_can_view() {
        $cap = get_option('at_view_capability', 'read');
        return current_user_can($cap);
    }

    public static function current_user_can_delete() {
        $cap = get_option('at_delete_capability', 'delete_posts');
        return current_user_can($cap);
    }
}
